/*
 * eight bouncing squares
 *
 * al kossow (AED)
 * april 1984
 */

#include <stdio.h>
FILE *fp;

#ifdef RT11
#define DEVICE "GD:","wn"
int $$narg = 1;
#endif

#ifndef RT11
#define DEVICE "/dev/aedbytes","w"
#endif

#define UPXUPY 1
#define UPXDNY 2
#define DNXUPY 3
#define DNXDNY 4
#define RAND   -1

#define TOP	700
#define BOT	50
#define LEFT	100
#define RIGHT	1000

/*
 * MUST be even!!
 */

#define RAYLEN 10

struct clrt {
		char r;
		char g;
		char b;
	    };

/*
 * drag in a hierarchical color table synthesisied by "mkhier.c"
 */

#include "hier.tbl"

/*
 * define some balls..
 */

struct ball {
	int	x;
	int	y;
	int	dir;
	int	idx;
	int	clr;
	int	mask;
       };

struct ball ball1[] = {
		200,  100,  DNXDNY, 10, 0x01, 0x01,
		300,  300,  UPXDNY, 10, 0x02, 0x02,
		400,  400,  UPXDNY, 10, 0x04, 0x04,
		500,  300,  DNXUPY, 10, 0x08, 0x08,
		400,  310,  UPXDNY, 10, 0x10, 0x10,
		30,   310,  DNXUPY, 10, 0x20, 0x20,
		50,   310,  DNXDNY, 10, 0x40, 0x40,
		500,  210,  UPXUPY, 10, 0x80, 0x80,
		200,  105,  DNXUPY, 10, 0x01, 0x01,
		300,  205,  UPXDNY, 10, 0x02, 0x02,
		400,  305,  UPXUPY, 10, 0x04, 0x04,
		500,  405,  DNXDNY, 10, 0x08, 0x08,
		400,  505,  UPXUPY, 10, 0x10, 0x10,
		-1,   0,    0,       0, 0,    0
		};

struct ball ball2[] = {
		200,  100,  DNXDNY, 10, 0x00, 0x01,
		300,  300,  UPXDNY, 10, 0x00, 0x02,
		400,  400,  UPXDNY, 10, 0x00, 0x04,
		500,  300,  DNXUPY, 10, 0x00, 0x08,
		400,  310,  UPXDNY, 10, 0x00, 0x10,
		30,   310,  DNXUPY, 10, 0x00, 0x20,
		50,   310,  DNXDNY, 10, 0x00, 0x40,
		500,  210,  UPXUPY, 10, 0x00, 0x80,
		200,  105,  DNXUPY, 10, 0x00, 0x01,
		300,  205,  UPXDNY, 10, 0x00, 0x02,
		400,  305,  UPXUPY, 10, 0x00, 0x04,
		500,  405,  DNXDNY, 10, 0x00, 0x08,
		400,  505,  UPXUPY, 10, 0x00, 0x10,
		-1,   0,    0,      9,  0,    0
		};

main()
{
	register struct ball *bp;
	register struct clrt *tp;
	register i;

	if((fp=fopen(DEVICE))==NULL){
	 puts("Can't open graphics terminal\n");
	 exit();
	}

	fprintf(fp,"\033G18888~");
/*
 * set up the hierarchical color table
 */
	tp = &clrt[0];
	for(i=0; i<256; i++){
	 putw((i<<8)|'K',fp);
	 putw(((tp->r&0xff)<<8)|1,fp);
	 putw(((tp->b&0xff)<<8)|(tp->g&0xff),fp);
	 tp++;
	}
/*
 * draw the outline of the region
 */
/*	putw((0xff<<8)|'C',fp);
	mov(LEFT,BOT);
	drw(LEFT,TOP);
	drw(RIGHT,TOP);
	drw(RIGHT,BOT);
	drw(LEFT,BOT);
*/

/*
 *
 */
	while(1){

	  bp = &ball1[0];
	  while(bp->x >= 0){
	   next(bp);
	   bp++;
	  }

	 for(i=0; i<RAYLEN; i++){
	  bp = &ball1[0];
	  while(bp->x >= 0){
	   next(bp);
	   bp++;
	  }
	 }

	 for(i=0; i<RAYLEN; i++){
	  bp = &ball2[0];		/* erasers... */
	  while(bp->x >= 0){
	   next(bp);
	   bp++;
	  }
	 }

	  bp = &ball1[0];
	  while(bp->x >= 0){
	   next(bp);
	   bp++;
	  }

	 for(i=0; i<2; i++){
	  bp = &ball2[0];		/* erasers... */
	  while(bp->x >= 0){
	   next(bp);
	   bp++;
	  }
	 }

	}
}	 

next(bp)
register struct ball *bp;
{
	 switch(bp->dir){
	  case UPXUPY:
	   if((bp->y+bp->idx)>=TOP){
	    bp->dir = UPXDNY;
	    break;
	   }
	   if((bp->x+bp->idx)>=RIGHT){
	    bp->dir =DNXUPY;
	    break;
	   }
	  bp->x += bp->idx; bp->y += bp->idx;
	  rec(bp->x,bp->y,bp->clr,bp->mask);
	  break;

	  case UPXDNY:
	   if((bp->x+bp->idx)>=RIGHT){
	    bp->dir = DNXDNY;
	    break;
	   }
	   if((bp->y-bp->idx)<=BOT){
	    bp->dir = UPXUPY;
	    break;
	   }
	   bp->x += bp->idx; bp->y -= bp->idx;
	   rec(bp->x,bp->y,bp->clr,bp->mask);
	   break;

	  case DNXUPY:
	   if((bp->x-bp->idx)<=LEFT){
	    bp->dir = UPXUPY;
	    break;
	   }
	   if((bp->y+bp->idx)>=TOP){
	    bp->dir = DNXDNY;
	    break;
	   }
	   bp->x -= bp->idx; bp->y += bp->idx;
	   rec(bp->x,bp->y,bp->clr,bp->mask);
	   break;

	  case DNXDNY:
	   if((bp->x-bp->idx)<=LEFT){
	    bp->dir = UPXDNY;
	    break;
	   }
	   if((bp->y-bp->idx)<=BOT){
	    bp->dir = DNXUPY;
	    break;
	   }
	   bp->x -= bp->idx; bp->y -= bp->idx;
	   rec(bp->x,bp->y,bp->clr,bp->mask);
	   break;
	 }
}

mov(x,y){
	register unsigned hxy,lxy;
	hxy  = (x&0xf00)<<4;
	hxy |= (y&0xf00);
	hxy |= 'Q';
	lxy = ((y&0xff)|(x&0xff));
	putw(hxy,fp);
	putw(lxy,fp);
}

drw(x,y){
	register unsigned hxy,lxy;
	hxy  = (x&0xf00)<<4;
	hxy |= (y&0xf00);
	hxy |= 'A';
	lxy = ((y&0xff)|(x&0xff));
	putw(hxy,fp);
	putw(lxy,fp);
}

rec(x,y,clr,mask){
	register unsigned xyh,xyl;
	xyh = (x&0xf00)<<4;
	xyh |= (y&0xf00);
	xyh |= 'Q';
	xyl = (((y&0xff)<<8)|(x&0xff));
	putw(xyh,fp);
	putw(xyl,fp);
	putw((mask<<8)|'L',fp);
	putw((clr<<8)|'C',fp);
	putc(',',fp);
	putw((10<<8)|10,fp);
}


